package gov.va.med.mhv.portal.backing;


import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.usermgmt.util.DirectorUtil;
import com.bea.netuix.servlets.controls.application.backing.DesktopBackingContext;
import com.bea.netuix.servlets.controls.content.backing.AbstractJspBacking;
import com.bea.netuix.servlets.controls.page.BookBackingContext;
import com.bea.netuix.servlets.manager.AppContext;
import com.bea.portlet.GenericURL;
import com.bea.portlet.PostbackURL;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import gov.va.med.mhv.usermgmt.portlet.constants.SessionAttributeConstants;
import gov.va.med.mhv.usermgmt.portlet.login.loginbase.LoginNavigateBaseController;

public class DesktopNavigationBacking extends AbstractJspBacking {


	private static final Log LOG = LogFactory.getLog(DesktopNavigationBacking.class);


/**
* Handles the postback data.
* Activates a book/page if the conditions are fulfilled.
* @param HttpServletRequest request the request
* @param HttpServletResponse response the response
*/
public boolean handlePostbackData(HttpServletRequest request, HttpServletResponse response) {

    //System.out.println("DesktopNavigationBacking::handlePostbackData()");

    //Get current label
    String pageLabel = (String) request.getParameter("_pageLabel");
    //System.out.println("Page Label for the first time:: " + pageLabel);

    //get the desktop backing context
    DesktopBackingContext desktopBacking = DesktopBackingContext.getDesktopBackingContext(request);

    BookBackingContext bookCtx = desktopBacking.getBookBackingContextRecursive(pageLabel);

    //check if page label matches a book label
    if (bookCtx != null ) {
        //System.out.println("DesktopNavigationBacking::handlePostbackData() --- starting");

        //get the postback url
        PostbackURL url = PostbackURL.createPostbackURL( request, response );

        /*
         * CR 3023; forcing the user to go to https protocol
         */
		String defaultProtocol = "https";
		url.setScheme(defaultProtocol);

        //Turn off the tree otimization
        url.addParameter(GenericURL.TREE_OPTIMIZATION_PARAM, "false");

        //remove the previously addressed page label
        url.removeParameter(GenericURL.PAGE_LABEL_PARAM);
        //System.out.println("GenericURL.PAGE_LABEL_PARAM   = "+GenericURL.PAGE_LABEL_PARAM );

        //change the page label to the definition label of the requested page
        url.addParameter(GenericURL.PAGE_LABEL_PARAM, bookCtx.getDefaultPage() );
        //System.out.println("url = "+url.toString());

        try {
            //redirect to the required page
            response.sendRedirect(url.toString());
        } catch (IOException e) {
            //log the error
            return false;
        }
        return true;

    }
    return false;
  }
     /**
        * preRender is called for each request prior to the rendering of any jsp files, etc.
        */
       public boolean preRender(HttpServletRequest request, HttpServletResponse response) {

           updateAppTitle(request);

           // Always add the no-cache headers to the response
           configureResponse(response);
		   // *********************************************************
           //NSOC Cross Site Scripting Issue
		   //UPDATE: Removed since it is handled by ServletFilter.
		   //03/19/2014: PUT IT BACK as XSS filter is removed now.
		   //03/20/2014: XSS Filter is enabled.
		   //checkForXSSScriptTags(request,response);

           if ( ! isUserAuthenticated(request) ) {
        	   if ( requiresAuthentication(request)) {
        		   String redirectURL = DirectorUtil.getDefaultAnonymousPortalPage(request, response);
                   redirect(response, redirectURL);
                   return false;
        	   } else {
        		   return ensureHttps(request, response); // user not authenticated, but authentication not needed
        	   }
           }
           String postLoginUrl = this.getPostLoginRedirectPage(request, response);
           if ( postLoginUrl != null ) {
				redirect(response, postLoginUrl);
        		return false;
           }
           // User is completely logged in
           return ensureHttps(request, response);
       }

       //NSOC Cross Site Scripting Issue
	   //UPDATE: Not used anymore since it is handled by ServletFilter.
       private void checkForXSSScriptTags(HttpServletRequest request, HttpServletResponse response) {
    	HttpServletRequest outerRequest = ScopedServletUtils.getOuterRequest(request);

    	if (outerRequest.getQueryString() != null) {
			if(outerRequest.getQueryString().contains("<script") || outerRequest.getQueryString().contains("%3Cscript")
					|| outerRequest.getQueryString().contains("%3cscript") || outerRequest.getQueryString().contains("&#60;script")
					|| outerRequest.getQueryString().contains("img%20src") || outerRequest.getQueryString().contains("img src")){

		    	LOG.warn(" Found XSS tags in the URL: outerRequest.getQueryString() in checkForXSSScriptTags ****: " + outerRequest.getQueryString());

				String redirectURL = DirectorUtil.getDefaultAnonymousPortalPage(request, response);
				redirect(response,redirectURL);
			}
    	}

	}
	/**
        * Checks to see if the url was https.  If the requested URL is not secure it sends a redirect
        *  to the same page except with the protocol and port number changed.
        * @param request
        * @param response
        * @return true if the request is https
        */
       private boolean ensureHttps(HttpServletRequest request, HttpServletResponse response) {
    	   if (isSSL(request)) {
				return true;
			} else {
	        	String redirectToSSLURL = DirectorUtil.getSecurePortalPage(request, response);
	            redirect(response, redirectToSSLURL);
	            return false;
			}
       }

       /**
        *
        * @param request
        * @return true if the page requires an authenticated user
        */
       private boolean requiresAuthentication(HttpServletRequest request) {
    	   if (request.getRequestURI().indexOf("anonymous.portal") != -1) {
    		   // Requesting the anonymous portal
    		   return false;
    	   } else if (request.getRequestURI().indexOf("eauth.portal") != -1 &&
                        request.getSession().getAttribute("eauthHash") != null) {
    		   // Requesting the eauth portal and session contains the eauth hash
    		   return false;
    	   }
    	   return true;
       }

       /**
        *
        * @param request
        * @return true if the user is authenticated.  This means only that the username and password
        * have been checked.  This method does NOT test post login logic like terms and conditions.
        */
       private boolean isUserAuthenticated(HttpServletRequest request) {
    	   return request.getRemoteUser() != null;
       }

       private boolean isPostLoginPage(HttpServletRequest request) {
    	   if ( request.getRequestURI().contains("termsAndConditions.portal") ) {
    		   String query = request.getQueryString();
    		   if ( query.contains("pageLabel=termsAndConditions")) return true;
    		   if ( query.contains("pageLabel=changePassword")) return true;
    	   }
    	   return false;
       }

       /**
        *
        * @param request
        * @param response
        * @return The url if there is post login processing to do and the user is not already
        * going to a post login page, else null
        */
       private String getPostLoginRedirectPage(HttpServletRequest request, HttpServletResponse response) {
    	   Boolean plDone = (Boolean)request.getSession().getAttribute(SessionAttributeConstants.POST_LOGIN_LOGIC_COMPLETE);
    	   if ( plDone != null && plDone.booleanValue() ) {
    		   LOG.debug("Post login complete flag found in session");
    		   return null;
    	   }
    	   if ( isPostLoginPage(request) ) {
    		   LOG.debug("getPostLoginPage isPostLoginPage = true");
				return null;
    	   } else if ( needsTAndC(request) ) {
    		   LOG.debug("getPostLoginPage needsTandC = true");
				return getTermsAndConditionsRedirectURL(request, response);
    	   } else if ( isPasswordTemporary(request) ) {
    		   LOG.debug("getPostLoginPage needsTandC = true");
				return getChangeTemporaryPasswordURL(request, response);
    	   } else {
    		   // Passed all tests.  Set session attribute so future requests return quicker
    		   request.getSession().setAttribute(SessionAttributeConstants.POST_LOGIN_LOGIC_COMPLETE, Boolean.TRUE);
    		   return null;
    	   }
       }

       protected boolean needsTAndC(HttpServletRequest request) {
    	   return ! (LoginNavigateBaseController.hasTermsBeenAccepted(request) );
       }

       protected boolean isPasswordTemporary(HttpServletRequest request) {
    	   return LoginNavigateBaseController.hasTemporaryPassword(request);
       }

       private String getTermsAndConditionsRedirectURL(HttpServletRequest request, HttpServletResponse response){
    	   // return DirectorUtil.getTermsAndConditionsRedirectURL(request);
    	   PostbackURL url = PostbackURL.createPostbackURL(request, response);
			url.removeParameter(GenericURL.PAGE_LABEL_PARAM);
			url.addParameter(GenericURL.PAGE_LABEL_PARAM, "termsAndConditions");
			url.setPath("/" + AppContext.getAppContext(request).getWebAppName()
					+ "/termsAndConditions.portal");
			return url.toString();
       }

       private String getChangeTemporaryPasswordURL(HttpServletRequest request, HttpServletResponse response) {
    	   // return DirectorUtil.getChangeTemporaryPasswordURL(request);
    	   PostbackURL url = PostbackURL.createPostbackURL(request, response);
			url.removeParameter(GenericURL.PAGE_LABEL_PARAM);
			url.addParameter(GenericURL.PAGE_LABEL_PARAM, "changePassword");
			url.setPath("/" + AppContext.getAppContext(request).getWebAppName()
					+ "/termsAndConditions.portal");
			return url.toString();
       }
       /**
        * Set response headers so that JSPs will not cache within the
        * browser.
        *
        * @param response The response being returned
        */
       private void configureResponse(HttpServletResponse response) {
    	   response.setHeader("Pragma", "No-cache");
    	   response.setHeader("Cache-Control", "no-cache");
    	   response.setDateHeader("Expires", 1);
       }

   	  private static boolean isSSL(HttpServletRequest request) {
		return request.getScheme().equalsIgnoreCase("https");
   	  }

	    /**
        * updates the application title to match the current page title
        * if page title does not exist, default to My HealtheVet
        */
       private void updateAppTitle(HttpServletRequest request){

           String browserTitle ="My HealtheVet  ";
           String pageTitle = (String)request.getSession().getAttribute("PageTitle");

           browserTitle = browserTitle + ((pageTitle!= null) ? " - " + pageTitle : "");

            // Set the browsers title
           AppContext.getAppContext(request).setAppTitle(browserTitle);
    }


	/**
	 * Simple redirect utility for this class
	 */
	private void redirect(HttpServletResponse response, String url) {
		try {

			if (LOG.isDebugEnabled()) {
				LOG.debug("Redirecting to the following URL in the redirect method of the backing file: " + response.encodeRedirectURL(url.toString()));
			}

			// Uncomment the below code and use it if the session is not propagated to the redirect URL
			//HttpSession session = request.getSession();
			//response.sendRedirect(url+";jsessionid="+session.getId());

			response.sendRedirect(response.encodeRedirectURL(url.toString()));

		} catch (Exception ex) {
			throw new RuntimeException("Unable to forward to URL " + url, ex);
		}
	}

}

